<?php


/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/OA/Dll.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/lib/OX/Admin/Redirect.php';
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/lib/OX/Plugin/Component.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
 $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);
$title="User Management";
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

// Create a new option object for displaying the setting's page's HTML form
$oOptions = new OA_Admin_Option('settings');
$prefSection = "banner-approve";

// Set the correct section of the settings pages and display the drop-down menu
$setPref = $oOptions->getSettingsPreferences($prefSection);
$title = $setPref[$prefSection]['name'];

// Display the settings page's header and sections
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader('account-settings-index', $oHeaderModel);

// Prepare an array for storing error messages

$aErrormessage = array();
$a='//'.$GLOBALS['conf']['webpath']['admin'].'/';

?>
<!--
<link rel="stylesheet" type="text/css" href="//cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css" />
-->

<script src="assets/js/jquery-1.12.4.js"></script>

<script src="assets/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" type="text/css" href="assets/css/jquery.dataTables.min.css" />
<script type="text/javascript">
	var jq = jQuery.noConflict();
	jq.browser = {};
	(function () {
		jq.browser.msie = false;
		jq.browser.version = 0;
		if (navigator.userAgent.match(/MSIE ([0-9]+)\./)) {
			jq.browser.msie = true;
			jq.browser.version = RegExp.$1;
		}
	})();
	jq(document).ready(function() {
			
		jq('#example').DataTable();
	});
	

	function induselect() {	 

		 if (jq('.cb-element:checked').length ==0){
		  jq('#selectval').prop('checked',false);
				jq('#ApproveSelection').parent().addClass( "inactive" );
				jq('#RejectSelection').parent().addClass( "inactive" );
				jq('#DeleteSelection').parent().addClass( "inactive" );
		 }
		 if (jq('.cb-element:checked').length >0){
		  jq('#selectval').prop('checked',false);
				jq('#ApproveSelection').parent().removeClass( "inactive" );
				jq('#RejectSelection').parent().removeClass( "inactive" );
				jq('#DeleteSelection').parent().removeClass( "inactive" );
		 }
		 if (jq('.cb-element:checked').length == jq('.cb-element').length){
			jq('#selectval').prop('checked',true);
			jq('#ApproveSelection').parent().removeClass( "inactive" );
			jq('#RejectSelection').parent().removeClass( "inactive" );
			jq('#DeleteSelection').parent().removeClass( "inactive" );		
		 }
	}	
	
	function selectall(event) {
		checkboxes = document.getElementsByName('foo');
	  
		if(document.getElementById("selectval").checked)
		{
			
			jq('#ApproveSelection').parent().removeClass( "inactive" );
			jq('#RejectSelection').parent().removeClass( "inactive" );
			jq('#DeleteSelection').parent().removeClass( "inactive" );
			
		}else
		{
			jq('#ApproveSelection').parent().addClass( "inactive" );
			jq('#RejectSelection').parent().addClass( "inactive" );
			jq('#DeleteSelection').parent().addClass( "inactive" );		
		}
		
		for(var i=0, n=checkboxes.length;i<n;i++) {
		 
			checkboxes[i].checked = event.checked;
		}
	}
</script>
<div class="tableWrapper">
<?php 
$query = "Select * from {$table_prefix}banners where status='1' and admin_approve='0'";

$query_row = OA_Dal_Delivery_query($query);

if(OA_Dal_Delivery_numRows($query_row)>0){
?>
<div class="tableHeader">
		<ul class="tableActions">       
            
            <li class="inactive activeIfSelected">	
               <a id='ApproveSelection' href=""><img src="assets/images/adxactive.png" width="15px" height="15px">&nbsp;Approve</a> 
              <script>
              jq('#ApproveSelection').click(function(event) { 
		
					event.preventDefault();     
						
					if (!jq(this).parents('li').hasClass('inactive')) {
						var ids = [];
					   
					   jq(this).parents('.tableWrapper').find("#example tbody tr td .cb-element:checked").each(function() {
							ids.push(this.value);
						});
						
						window.location.href = 'oxm_allbanner_approve.php?value=approve&bid=' + ids.join(',');
					}
				
				});
              
              </script>
				        	  
				        	             
            </li>            
            <li class="inactive activeIfSelected">	
				<a id='RejectSelection' href=""><img src="assets/images/adxdeactive.png" width="15px" height="15px">&nbsp;Reject</a> 
				<script>
					jq('#RejectSelection').click(function(event) {  
						event.preventDefault();     
						
						if (!jq(this).parents('li').hasClass('inactive')) {
							var ids = [];
						   
						   jq(this).parents('.tableWrapper').find("#example tbody tr td .cb-element:checked").each(function() {
								ids.push(this.value);
							});
							//~ alert(ids);
							window.location = 'oxm_allbanner_approve.php?value=reject&bid=' + ids.join(',');
						}
					
					});				
				</script>
			          	             
            </li>            
            <li class="inactive activeIfSelected">	
				<a id='DeleteSelection' href=""><img src="assets/images/cross.png" width="15px" height="15px">&nbsp;Delete</a> 
				<script>
					jq('#DeleteSelection').click(function(event) {  
						event.preventDefault();     
						
						if (!jq(this).parents('li').hasClass('inactive')) {
							var ids = [];
						   
						   jq(this).parents('.tableWrapper').find("#example tbody tr td .cb-element:checked").each(function() {
								ids.push(this.value);
							});
							//~ alert(ids);
							window.location = 'oxm_allbanner_approve.php?value=delete&bid=' + ids.join(',');
						}
					
					});
				</script>
			          	     	             
            </li>            
        </ul>

        <div class="clear"></div>
        <div class="corner left"></div>
        <div class="corner right"></div>
    </div>

<table width="100%" id="example" class="display">
	
	<thead>
		<tr>
			
			
			
			<td><input type="checkbox" id="selectval" value="multiple" onClick="selectall(this)"></td>
			<td><font size='2'><b>Banner Name</b></td>
			<td><font size='2'><b>Banner Type</b></td>
			<td><font size='2'><b>View Banner</b></td>
			<td><font size='2'><b>Action</b></td>
		</tr>
	</thead>


<?php 
	
	$all_bannerid = [];
	
	while($banner = OA_Dal_Delivery_fetchAssoc($query_row)){
	
		
?>
		<tr>
			<td>
				<input type="checkbox" name="foo" value="<?php echo $banner['bannerid'];?>" class="cb-element" onClick="induselect()">
			</td>
			<td>
				<font size='2'><?php echo $banner['description']?></font>
			</td>
			<td>
				<font size='2'><?php echo  $banner['storagetype']?></font>
			</td>
			<td>
				<font size='2'><a href="javascript: void(0)" onclick="window.open('oxm_banner_info.php?bannerid=<?php echo $banner['bannerid']?>','Banner Info','width=500,height=500,scrollbars=1')">Banner Info</a></font>
			</td>
			<td>
				<font size='2'><a href="oxm_banner_approve.php?bannerid=<?php echo $banner['bannerid']?>&value=1">Activate</a> </font>/ 
				<font size='2'><a href="oxm_banner_approve.php?bannerid=<?php echo $banner['bannerid']?>&value=0">Reject</a> </font>/
				<font size='2'><a href="oxm_banner_approve.php?bannerid=<?php echo $banner['bannerid']?>&value=2">Delete</a>
			</td> 
		</tr>
<?php 

		$all_bannerid[] = $banner['bannerid'];
	}

?>

<input type ="hidden" id ="allbannerid" name="allbanner" value="<?php echo $all_bannerid; ?>">

</table>
<?php
}
else
{?>
	<div class="errormessage">
		Currently there are No Banners yet to be Approved.</div><?php
}
?>
</div>

<?php
/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/
phpAds_PageFooter();

?>

